<?php 

/*******************************************************************************************/
/*		GNU/GPL License
/*		Designed by 'AS Designing'
/*		Web: http://www.asdesigning.com
/*		Web: http://www.astemplates.com
/*
/*******************************************************************************************/


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// General Body Parameters
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Body patterns and colors

$body_bgpattern = 'black';
$body_bgcolor = 'F4F4F4';
$body_bordercolor = 'CCCCCC';
$body_borderinnercolor = 'FFFFFF';
$body_formbgcolor = 'FFFFFF';

if($this->params->get('body_bgpattern'))
{
	$body_bgpattern = $this->params->get('body_bgpattern');
}
if($this->params->get('body_bgcolor'))
{
	$body_bgcolor = $this->params->get('body_bgcolor');
}
if($this->params->get('body_bordercolor'))
{
	$body_bordercolor = $this->params->get('body_bordercolor');
}
if($this->params->get('body_borderinnercolor'))
{
	$body_borderinnercolor = $this->params->get('body_borderinnercolor');
}
if($this->params->get('body_formbgcolor'))
{
	$body_formbgcolor = $this->params->get('body_formbgcolor');
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Body Fonts

$body_fontsize = '12px';
$body_fontstyle = 'normal';
$body_fontweight = 'normal';
$body_fontfamily = 'Tahoma, Arial, Geneva, Verdana, sans-serif';
$body_fontcolor = '3F3C38';
$body_hfontsize = '15px';
$body_hfontweight = 'bold';

if ($this->params->get('body_fontsize')) 
{ 
	$body_fontsize = $this->params->get('body_fontsize'); 
}
if ($this->params->get('body_fontstyle')) 
{ 
	$body_fontstyle = $this->params->get('body_fontstyle'); 
}
if ($this->params->get('body_fontweight')) 
{ 
	$body_fontweight = $this->params->get('body_fontweight'); 
}
if ($this->params->get('body_fontfamily')) 
{ 
	$body_fontfamily = $this->params->get('body_fontfamily'); 
}
if ($this->params->get('body_fontcolor'))
{
	$body_fontcolor = ($this->params->get('body_fontcolor'));
}
if ($this->params->get('body_hfontsize')) 
{ 
	$body_hfontsize = $this->params->get('body_hfontsize'); 
}
if ($this->params->get('body_hfontweight'))
{
	$body_hfontweight = $this->params->get('body_hfontweight');
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Body Links & Buttons

$body_errormsgcolor = '990000';
$body_hwordcolor = $body_errormsgcolor;

$body_linkcolor = '3F3C38';
$body_linkcolorhover = '990000';

$body_btn_bgcolor = '000000';
$body_btn_bgcolorhover = '990000';

$body_btn_fontcolor = 'FFFFFF';
$body_btn_fontcolorhover = 'FFFFFF';

switch($body_bgpattern)
{
	case 'autumn':
		$body_errormsgcolor = 'FFA41C';
		$body_hwordcolor = $body_errormsgcolor;
		$body_linkcolorhover = '622713';
		$body_btn_bgcolor = '6C2111';
		$body_btn_bgcolorhover = 'FFA41C';
		break;
	case 'black':
		$body_errormsgcolor = '990000';
		$body_hwordcolor = $body_errormsgcolor;
		$body_linkcolorhover = '990000';
		$body_btn_bgcolor = '000000';
		$body_btn_bgcolorhover = '990000';
		break;
	case 'forest':
		$body_errormsgcolor = 'FFA41C';
		$body_hwordcolor = $body_errormsgcolor;
		$body_linkcolorhover = 'FFA41C';
		$body_btn_bgcolor = '364518';
		$body_btn_bgcolorhover = 'FFA41C';
		break;
	case 'royal':
		$body_errormsgcolor = 'FFA41C';
		$body_hwordcolor = $body_errormsgcolor;
		$body_linkcolorhover = 'FFA41C';
		$body_btn_bgcolor = '1E3253';
		$body_btn_bgcolorhover = 'FFA41C';
		break;
	case 'silver':
		$body_errormsgcolor = 'FFA41C';
		$body_hwordcolor = $body_errormsgcolor;
		$body_linkcolorhover = 'FFA41C';
		$body_btn_bgcolor = '5C5C5C';
		$body_btn_bgcolorhover = 'FFA41C';
		break;
}

if($this->params->get('body_errormsgcolor') && $body_bgpattern == 'custom')
{
	$body_errormsgcolor = $this->params->get('body_errormsgcolor');
	$body_hwordcolor = $body_errormsgcolor;
}
if($this->params->get('body_linkcolor'))
{
	$body_linkcolor = $this->params->get('body_linkcolor');
}
if($this->params->get('body_linkcolorhover') && $body_bgpattern == 'custom')
{
	$body_linkcolorhover = $this->params->get('body_linkcolorhover');
}
if($this->params->get('body_btn_bgcolor') && $body_bgpattern == 'custom')
{
	$body_btn_bgcolor = $this->params->get('body_btn_bgcolor');
}
if($this->params->get('body_btn_bgcolorhover') && $body_bgpattern == 'custom')
{
	$body_btn_bgcolorhover = $this->params->get('body_btn_bgcolorhover');
}
if($this->params->get('body_btn_fontcolor'))
{
	$body_btn_fontcolor = $this->params->get('body_btn_fontcolor');
}
if($this->params->get('body_btn_fontcolorhover'))
{
	$body_btn_fontcolorhover = $this->params->get('body_btn_fontcolorhover');
}

$jquery_load = '';
if($this->params->get('jQuery_load'))
{
	$jquery_load = $this->params->get('jQuery_load');
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header parameters
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 1 Parameters (Top navigation bar)
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row1_bgcolor = '000000';

$topnavbar_position = 'right';
$topnavbar_linkcolor = 'FFFFFF';
$topnavbar_linkcolorhover = '990000';

switch($body_bgpattern)
{
	case 'autumn':
		$header_row1_bgcolor = '530F00';
		$topnavbar_linkcolorhover = 'F29948';
		break;
	case 'black':
		$header_row1_bgcolor = '000000';
		$topnavbar_linkcolorhover = '990000';
		break;		
	case 'forest':
		$header_row1_bgcolor = '222E00';
		$topnavbar_linkcolorhover = 'FFA41C';
		break;
	case 'royal':
		$header_row1_bgcolor = '13223C';
		$topnavbar_linkcolorhover = 'FFA41C';
		break;
	case 'silver':
		$header_row1_bgcolor = '5C5C5C';
		$topnavbar_linkcolorhover = 'FFA41C';
		break;
}

if ($this->params->get('header_row1_bgcolor') && $body_bgpattern == 'custom') 
{ 
	$header_row1_bgcolor = $this->params->get('header_row1_bgcolor'); 
}
if ($this->params->get('topnavbar_position')) 
{ 
	$topnavbar_position = $this->params->get('topnavbar_position'); 
}
if ($this->params->get('topnavbar_linkcolor')) 
{ 
	$topnavbar_linkcolor = $this->params->get('topnavbar_linkcolor'); 
}
if ($this->params->get('topnavbar_linkcolorhover') && $body_bgpattern == 'custom') 
{ 
	$topnavbar_linkcolorhover = $this->params->get('topnavbar_linkcolorhover'); 
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$linkimg_home = $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/btn.home.png';
$linkimg_contact = $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/btn.contact.png';
$linkimg_search = $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/btn.search.png';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 2 Parameters (Logo & Top Menu )
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row2_bgcolor = '000000';

if ($this->params->get('header_row2_bgcolor') && $body_bgpattern == 'custom') 
{ 
	$header_row2_bgcolor = $this->params->get('header_row2_bgcolor'); 
}

switch($body_bgpattern)
{
	case 'autumn':
		$header_row2_bgcolor = '6C2111';
		break;
	case 'black':
		$header_row2_bgcolor = '000000';
		break;		
	case 'forest':
		$header_row2_bgcolor = '364518';
		break;		
	case 'royal':
		$header_row2_bgcolor = '1E3253';
		break;		
	case 'silver':
		$header_row2_bgcolor = '5C5C5C';
		break;		
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 2 (Top Menu)

$topmenu_parentmark = $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/mark.parent.png';

$topmenu_linkcolor = 'FFFFFF';
$topmenu_linkcolorhover = '000000';
$topmenu_btn_bgcolor = '990000';

switch($body_bgpattern)
{
	case 'autumn':
		$topmenu_btn_bgcolor = 'FFA41C';
		$topmenu_linkcolorhover = '6C2111';
		break;
	case 'black':
		$topmenu_btn_bgcolor = '990000';
		$topmenu_linkcolorhover = '000000';
		break;	
	case 'forest':
		$topmenu_btn_bgcolor = '222E00';
		$topmenu_linkcolorhover = 'FFA41C';
		break;	
	case 'royal':
		$topmenu_btn_bgcolor = '13223C';
		$topmenu_linkcolorhover = 'FFA41C';
		break;	
	case 'silver':
		$topmenu_btn_bgcolor = '333333';
		$topmenu_linkcolorhover = 'FFA41C';
		break;			
}

if ($this->params->get('topmenu_linkcolor')) 
{ 
	$topmenu_linkcolor = $this->params->get('topmenu_linkcolor'); 
}
if ($this->params->get('topmenu_linkcolorhover') && $body_bgpattern == 'custom')
{ 
	$topmenu_linkcolorhover = $this->params->get('topmenu_linkcolorhover'); 
}
if ($this->params->get('topmenu_btn_bgcolor') && $body_bgpattern == 'custom')
{
	$topmenu_btn_bgcolor = $this->params->get('topmenu_btn_bgcolor');
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 2 (Logo)

$logo_type = '0';
$logo_bgcolor = '';
$logo_img = $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/companyname.png';

$logo_position = "left";
$logo_align = "left";
$logo_showbgimg = 1;
$logo_bgimg = $this->baseurl . '/templates/' . $this->template . '/images/bg.companyname.png';

if ($this->params->get('logo_type')) 
{ 
	$logo_type = $this->params->get('logo_type'); 
}
if (($this->params->get('logo_bgcolor')))
{
	$logo_bgcolor = $this->params->get('logo_bgcolor');
}
if ($this->params->get('logo_img')) 
{ 
	$logo_img = $this->params->get('logo_img');
	if($logo_img == 'companyname.png') 
	{
		$logo_img = $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/companyname.png';
	}
}
if (!$this->params->get('logo_showbgimg'))
{
	$logo_showbgimg = 0;
}
if ($this->params->get('logo_bgimg') && $logo_showbgimg) 
{ 
	$logo_bgimg = $this->baseurl . '/' . $this->params->get('logo_bgimg');
	if($this->params->get('logo_bgimg') == 'bg.companyname.png') 
	{
		$logo_bgimg = $this->baseurl . '/templates/' . $this->template . '/images/bg.companyname.png';
	}
}
elseif (!$logo_showbgimg) 
{
	$logo_bgimg = '';
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$logo_txt = '';
$logo_txtfontsize = '27px';
$logo_txtfontstyle = 'normal';
$logo_txtfontweight = 'bold';
$logo_txtfontfamily = $body_fontfamily;
$logo_txtcolor = 'FFFFFF';

if ($this->params->get('logo_txt')) 
{ 
	$logo_txt = htmlspecialchars($this->params->get('logo_txt')); 
}
if ($this->params->get('logo_txtfontsize')) 
{ 
	$logo_txtfontsize = $this->params->get('logo_txtfontsize'); 
}
if ($this->params->get('logo_txtfontstyle')) 
{ 
	$logo_txtfontstyle = $this->params->get('logo_txtfontstyle'); 
}
if ($this->params->get('logo_txtfontweight')) 
{ 
	$logo_txtfontweight = $this->params->get('logo_txtfontweight'); 
}
if ($this->params->get('logo_txtfontfamily')) 
{ 
	$logo_txtfontfamily = $this->params->get('logo_txtfontfamily'); 
}
if ($this->params->get('logo_txtcolor'))
{
	$logo_txtcolor = $this->params->get('logo_txtcolor');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 2 (Slogan)

$slogan_txt = '';
$slogan_txtfontsize = '10px';
$slogan_txtfontstyle = 'normal';
$slogan_txtfontweight = 'normal';
$slogan_txtfontfamily = $body_fontfamily;
$slogan_txtcolor = 'FFFFFF';

if ($this->params->get('slogan_txt')) 
{ 
	$slogan_txt = htmlspecialchars($this->params->get('slogan_txt')); 
}
if ($this->params->get('slogan_txtfontsize')) 
{ 
	$slogan_txtfontsize = $this->params->get('slogan_txtfontsize'); 
}
if ($this->params->get('slogan_txtfontstyle')) 
{ 
	$slogan_txtfontstyle = $this->params->get('slogan_txtfontstyle'); 
}
if ($this->params->get('slogan_txtfontweight')) 
{ 
	$slogan_txtfontweight = $this->params->get('slogan_txtfontweight'); 
}
if ($this->params->get('slogan_txtfontfamily')) 
{ 
	$slogan_txtfontfamily = $this->params->get('slogan_txtfontfamily'); 
}
if ($this->params->get('slogan_txtcolor'))
{
	$slogan_txtcolor = $this->params->get('slogan_txtcolor');
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 3 Parameters (Slider)
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row3_bgcolor = $body_bgcolor;

include 'params.slider.php';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 4 Parameters (Breadcrumbs & Search)
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row4_bgcolor = $body_bgcolor;
$header_row4_bgcontentcolor = '000000';
$header_row4_fontcolor = 'FFFFFF';

$search_bgcolor = '282828';

switch($body_bgpattern)
{
	case 'autumn':
		$header_row4_bgcontentcolor = '6C2111';
		$header_row4_fontcolor = 'FFA41C';
		$search_bgcolor = '85482B';
		break;
	case 'black':
		$header_row4_bgcontentcolor = '000000';
		$header_row4_fontcolor = 'FFFFFF';
		$search_bgcolor = '282828';
		break;		
	case 'forest':
		$header_row4_bgcontentcolor = '364518';
		$header_row4_fontcolor = 'FFFFFF';
		$search_bgcolor = '748941';
		break;
	case 'royal':
		$header_row4_bgcontentcolor = '1E3253';
		$header_row4_fontcolor = 'FFFFFF';
		$search_bgcolor = '37547E';
		break;
	case 'silver':
		$header_row4_bgcontentcolor = '5C5C5C';
		$header_row4_fontcolor = 'FFFFFF';
		$search_bgcolor = '787878';
		break;
}

if($body_bgpattern == 'custom')
{
	if ($this->params->get('header_row4_bgcontentcolor')) 
	{ 
		$header_row4_bgcontentcolor = $this->params->get('header_row4_bgcontentcolor'); 
	}
	if ($this->params->get('header_row4_fontcolor')) 
	{ 
		$header_row4_fontcolor = $this->params->get('header_row4_fontcolor'); 
	}
	if ($this->params->get('search_bgcolor')) 
	{ 
		$search_bgcolor = $this->params->get('search_bgcolor'); 
	}
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 5 Parameters (Slidenews)
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row5_bgcolor = $body_bgcolor;

$slidenews_bgcolor = $body_bgcolor;
$slidenews_fontcolor = $body_fontcolor;
$slidenews_linkcolor = $body_linkcolor;
$slidenews_linkcolorhover = $body_linkcolorhover;

if ($this->params->get('slidenews_bgcolor'))
{
	$slidenews_bgcolor = $this->params->get('slidenews_bgcolor');
}
if ($this->params->get('slidenews_fontcolor'))
{
	$slidenews_fontcolor = $this->params->get('slidenews_fontcolor');
}
if ($this->params->get('slidenews_linkcolor'))
{
	$slidenews_linkcolor = $this->params->get('slidenews_linkcolor');
}
if ($this->params->get('slidenews_linkcolorhover'))
{
	$slidenews_linkcolorhover = $this->params->get('slidenews_linkcolorhover');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$slidenews_border = $body_bordercolor;
$slidenews_innerborder = $body_borderinnercolor;

if ($this->params->get('slidenews_border'))
{
	$slidenews_border = $this->params->get('slidenews_border');
}
if ($this->params->get('slidenews_innerborder'))
{
	$slidenews_innerborder = $this->params->get('slidenews_innerborder');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$slidenews_scrollamount = '2';
if ($this->params->get('slidenews_scrollamount'))
{
	$slidenews_scrollamount = htmlspecialchars($this->params->get('slidenews_scrollamount'));
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 6 Parameters
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row6_bgcolor = $body_bgcolor;
$header_row6_bgcontentcolor = $body_bgcolor;
$header_row6_fontcolor = $body_fontcolor;
$header_row6_linkcolor = $body_linkcolor;
$header_row6_linkcolorhover = $body_linkcolorhover;

if ($this->params->get('header_row6_fontcolor'))
{
	$header_row6_fontcolor = $this->params->get('header_row6_fontcolor');
}
if ($this->params->get('header_row6_linkcolor'))
{
	$header_row6_linkcolor = $this->params->get('header_row6_linkcolor');
}
if ($this->params->get('header_row6_linkcolorhover'))
{
	$header_row6_linkcolorhover = $this->params->get('header_row6_linkcolorhover');
}

$header_row6_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.header.row6.png';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 6 Dimensions

$header_row6 = 0;
$header_row6 += (bool) $this->countModules('position-12');
$header_row6 += (bool) $this->countModules('position-13'); 
$header_row6 += (bool) $this->countModules('position-14'); 
$header_row6 += (bool) $this->countModules('position-15'); 

$header_row6_width = 'style="width:1002px;"';

if($header_row6 == 2)
{
	$header_row6_width = 'style="width:488px;"';	
}
else if($header_row6 == 3)
{
	$header_row6_width = 'style="width:317px;"';	
}
else if($header_row6 == 4)
{
	$header_row6_width = 'style="width:231px;"';	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 6 Separators

$header_row6_separator1 = 0;
$header_row6_separator2 = 0;
$header_row6_separator3 = 0;

$header_row6_separator1 += (bool)($this->countModules('position-12') && ($this->countModules('position-13') ||
                                               				    			$this->countModules('position-14') ||
                                              				    			$this->countModules('position-15')));

$header_row6_separator2 += (bool)($this->countModules('position-13') && ($this->countModules('position-14') || 
                                                                			$this->countModules('position-15')));
					
$header_row6_separator3 += (bool)($this->countModules('position-14') && ($this->countModules('position-15')));


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 7 Parameters
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row7_bgcolor = $body_bgcolor;
$header_row7_bgcontentcolor = '000000';
$header_row7_fontcolor = 'FFFFFF';
$header_row7_linkcolor = 'FFFFFF';
$header_row7_linkcolorhover = '990000';

$header_row7_btn_bgcolor = '990000';
$header_row7_btn_bgcolorhover = '990000';
$header_row7_btn_fontcolor = 'FFFFFF';
$header_row7_btn_fontcolorhover = '000000';

$header_row7_bordercolor = '000000';
$header_row7_innerbordercolor = '000000';

switch($body_bgpattern)
{
	case 'autumn':
		$header_row7_bgcontentcolor = '6C2111';
		$header_row7_linkcolorhover = 'FFA41C';
		$header_row7_btn_bgcolor = 'FFA41C';
		$header_row7_btn_bgcolorhover = 'FFA41C';
		$header_row7_btn_fontcolorhover = '622713';
		$header_row7_bordercolor = '6C2111';
		$header_row7_innerbordercolor = '803F32';		
		break;
	case 'black':
		$header_row7_bgcontentcolor = '000000';
		$header_row7_linkcolorhover = '990000';
		$header_row7_btn_bgcolor = '990000';
		$header_row7_btn_bgcolorhover = '990000';
		$header_row7_btn_fontcolorhover = '000000';
		$header_row7_bordercolor = '000000';
		$header_row7_innerbordercolor = '000000';	
		break;	
	case 'forest':
		$header_row7_bgcontentcolor = '364518';
		$header_row7_linkcolorhover = 'FFA41C';
		$header_row7_btn_bgcolor = '222E00';
		$header_row7_btn_bgcolorhover = 'FFA41C';
		$header_row7_btn_fontcolorhover = 'FFFFFF';
		$header_row7_bordercolor = '364518';
		$header_row7_innerbordercolor = '364518';	
		break;			
	case 'royal':
		$header_row7_bgcontentcolor = '1E3253';
		$header_row7_linkcolorhover = 'FFA41C';
		$header_row7_btn_bgcolor = '13223C';
		$header_row7_btn_bgcolorhover = 'FFA41C';
		$header_row7_btn_fontcolorhover = 'FFFFFF';
		$header_row7_bordercolor = '1E3253';
		$header_row7_innerbordercolor = '1E3253';		
		break;			
	case 'silver':
		$header_row7_bgcontentcolor = '5C5C5C';
		$header_row7_linkcolorhover = 'FFA41C';
		$header_row7_btn_bgcolor = '333333';
		$header_row7_btn_bgcolorhover = 'FFA41C';
		$header_row7_btn_fontcolorhover = '333333';
		$header_row7_bordercolor = '5C5C5C';
		$header_row7_innerbordercolor = '5C5C5C';		
		break;			
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

if ($this->params->get('header_row7_bgcontentcolor') && $body_bgpattern == 'custom')
{
	$header_row7_bgcontentcolor = $this->params->get('header_row7_bgcontentcolor');
}
if ($this->params->get('header_row7_fontcolor'))
{
	$header_row7_fontcolor = $this->params->get('header_row7_fontcolor');
}
if ($this->params->get('header_row7_linkcolor'))
{
	$header_row7_linkcolor = $this->params->get('header_row7_linkcolor');
}
if ($this->params->get('header_row7_linkcolorhover') && $body_bgpattern == 'custom')
{
	$header_row7_linkcolorhover = $this->params->get('header_row7_linkcolorhover');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


if ($this->params->get('header_row7_btn_bgcolor') && $body_bgpattern == 'custom')
{
	$header_row7_btn_bgcolor = $this->params->get('header_row7_btn_bgcolor');
}
if ($this->params->get('header_row7_btn_bgcolorhover') && $body_bgpattern == 'custom')
{
	$header_row7_btn_bgcolorhover = $this->params->get('header_row7_btn_bgcolorhover');
}
if ($this->params->get('header_row7_btn_fontcolor'))
{
	$header_row7_btn_fontcolor = $this->params->get('header_row7_btn_fontcolor');
}
if ($this->params->get('header_row7_btn_fontcolorhover') && $body_bgpattern == 'custom')
{
	$header_row7_btn_fontcolorhover = $this->params->get('header_row7_btn_fontcolorhover');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



if ($this->params->get('header_row7_bordercolor') && $body_bgpattern == 'custom')
{
	$header_row7_bordercolor = $this->params->get('header_row7_bordercolor');
}
if ($this->params->get('header_row7_innerbordercolor') && $body_bgpattern == 'custom')
{
	$header_row7_innerbordercolor = $this->params->get('header_row7_innerbordercolor');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$header_row7_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.header.row7.png';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 7 Dimensions

$header_row7 = 0;
$header_row7 += (bool) $this->countModules('position-16');
$header_row7 += (bool) $this->countModules('position-17'); 
$header_row7 += (bool) $this->countModules('position-18'); 
$header_row7 += (bool) $this->countModules('position-19'); 

$header_row7_width = 'style="width:950px;"';

if($header_row7 == 2)
{
	$header_row7_width = 'style="width:462px;"';	
}
else if($header_row7 == 3)
{
	$header_row7_width = 'style="width:300px;"';	
}
else if($header_row7 == 4)
{
	$header_row7_width = 'style="width:218px;"';	
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Header - Row 7 Separators


$header_row7_separator1 = 0;
$header_row7_separator2 = 0;
$header_row7_separator3 = 0;

$header_row7_separator1 += (bool)($this->countModules('position-16') && ($this->countModules('position-17') ||
                                               				  				$this->countModules('position-18') ||
                                              				   	 			$this->countModules('position-19')));

$header_row7_separator2 += (bool)($this->countModules('position-17') && ($this->countModules('position-18') || 
                                                                			$this->countModules('position-19')));
					
$header_row7_separator3 += (bool)($this->countModules('position-18') && ($this->countModules('position-19')));



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Left & Right Column Parameters
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$leftcolumn = 0;
$leftcolumn += (bool) $this->countModules('position-40');
$leftcolumn += (bool) $this->countModules('position-41');
$leftcolumn += (bool) $this->countModules('position-42');
$leftcolumn += (bool) $this->countModules('position-43');
$leftcolumn += (bool) $this->countModules('position-44');

$rightcolumn = 0;
$rightcolumn += (bool) $this->countModules('position-45');
$rightcolumn += (bool) $this->countModules('position-46');
$rightcolumn += (bool) $this->countModules('whosonlineload');
$rightcolumn += (bool) $this->countModules('position-47');
$rightcolumn += (bool) $this->countModules('position-48');
$rightcolumn += (bool) $this->countModules('position-49');

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$sidecolumn_hfontcolor = $body_fontcolor;
$sidecolumn_hfontsize = '17px';
$sidecolumn_hfontweight = 'normal';

if ($this->params->get('sidecolumn_hfontcolor'))
{
	$sidecolumn_hfontcolor = $this->params->get('sidecolumn_hfontcolor');
}
if ($this->params->get('sidecolumn_hfontsize'))
{
	$sidecolumn_hfontsize = $this->params->get('sidecolumn_hfontsize');
}
if ($this->params->get('sidecolumn_hfontweight'))
{
	$sidecolumn_hfontweight = $this->params->get('sidecolumn_hfontweight');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$sidecolumn_btn_bgcolor = '990000';
$sidecolumn_btn_bgcolorhover = '000000';

switch($body_bgpattern)
{
	case 'autumn':
		$sidecolumn_btn_bgcolor = '6C2111';
		$sidecolumn_btn_bgcolorhover = 'FFA41C';	
		break;
	case 'black':
		$sidecolumn_btn_bgcolor = '990000';
		$sidecolumn_btn_bgcolorhover = '000000';
		break;
	case 'forest':
		$sidecolumn_btn_bgcolor = '364518';
		$sidecolumn_btn_bgcolorhover = 'FFA41C';	
		break;				
	case 'royal':
		$sidecolumn_btn_bgcolor = '1E3253';
		$sidecolumn_btn_bgcolorhover = 'FFA41C';	
		break;				
	case 'silver':
		$sidecolumn_btn_bgcolor = '5C5C5C';
		$sidecolumn_btn_bgcolorhover = 'FFA41C';	
		break;				
}

if($body_bgpattern == 'custom')
{
	if ($this->params->get('sidecolumn_btn_bgcolor'))
	{
		$sidecolumn_btn_bgcolor = $this->params->get('sidecolumn_btn_bgcolor');
	}
	if ($this->params->get('sidecolumn_btn_bgcolorhover'))
	{
		$sidecolumn_btn_bgcolorhover = $this->params->get('sidecolumn_btn_bgcolorhover');
	}
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main column parameters
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Separator between Header and Content

$content_separator = 0;
$content_separator += (bool) $this->countModules('position-4');
$content_separator += (bool) $this->countModules('position-12');
$content_separator += (bool) $this->countModules('position-13');
$content_separator += (bool) $this->countModules('position-14');
$content_separator += (bool) $this->countModules('position-15');
$content_separator += (bool) $this->countModules('position-16');
$content_separator += (bool) $this->countModules('position-17');
$content_separator += (bool) $this->countModules('position-18');
$content_separator += (bool) $this->countModules('position-19');

if($content_separator > 0)
{
	$content_separator = 0;
}
else
{
	$content_separator = 20;
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Dimensions

$maincolumn_width = 'style="width:1002px"';
$maincolumn_cntwidth = 'style="width:1000px"';

if ($rightcolumn && $leftcolumn)
{
    $maincolumn_width = 'style="width:462px"';
	$maincolumn_cntwidth = 'style="width:460px"';
}
else if ((!$rightcolumn && $leftcolumn) || ($rightcolumn && !$leftcolumn))
{
	$maincolumn_width = 'style="width:732px"';
	$maincolumn_cntwidth = 'style="width:730px"';
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 1

$maincolumn_row1_bgcolor = '000000';
$maincolumn_row1_fontcolor = 'FFFFFF';

$maincolumn_row1_hfontcolor = 'FFFFFF';
$maincolumn_row1_hfontsize = '15px';
$maincolumn_row1_hfontweight = 'normal';

$maincolumn_row1_linkcolor = 'FFFFFF';
$maincolumn_row1_linkcolorhover = '990000';

$maincolumn_row1_bordercolor = '000000';
$maincolumn_row1_innerbordercolor = '000000';

switch($body_bgpattern)
{
	case 'autumn':
		$maincolumn_row1_bgcolor = '6C2111';
		$maincolumn_row1_linkcolorhover = 'FFA41C';
		$maincolumn_row1_bordercolor = '6C2111';
		$maincolumn_row1_innerbordercolor = '803F32';
		break;
	case 'black':
		$maincolumn_row1_bgcolor = '000000';
		$maincolumn_row1_linkcolorhover = '990000';
		$maincolumn_row1_bordercolor = '000000';
		$maincolumn_row1_innerbordercolor = '000000';
		break;	
	case 'forest':
		$maincolumn_row1_bgcolor = '364518';
		$maincolumn_row1_linkcolorhover = 'FFA41C';
		$maincolumn_row1_bordercolor = '364518';
		$maincolumn_row1_innerbordercolor = '364518';
		break;			
	case 'royal':
		$maincolumn_row1_bgcolor = '1E3253';
		$maincolumn_row1_linkcolorhover = 'FFA41C';
		$maincolumn_row1_bordercolor = '1E3253';
		$maincolumn_row1_innerbordercolor = '1E3253';
		break;			
	case 'silver':
		$maincolumn_row1_bgcolor = '5C5C5C';
		$maincolumn_row1_linkcolorhover = 'FFA41C';
		$maincolumn_row1_bordercolor = '5C5C5C';
		$maincolumn_row1_innerbordercolor = '5C5C5C';
		break;			
}

if ($this->params->get('maincolumn_row1_bgcolor') && $body_bgpattern == 'custom')
{
	$maincolumn_row1_bgcolor = $this->params->get('maincolumn_row1_bgcolor');
}
if ($this->params->get('maincolumn_row1_fontcolor'))
{
	$maincolumn_row1_fontcolor = $this->params->get('maincolumn_row1_fontcolor');
}
if ($this->params->get('maincolumn_row1_hfontcolor'))
{
	$maincolumn_row1_hfontcolor = $this->params->get('maincolumn_row1_hfontcolor');
}
if ($this->params->get('maincolumn_row1_hfontsize'))
{
	$maincolumn_row1_hfontsize = $this->params->get('maincolumn_row1_hfontsize');
}
if ($this->params->get('maincolumn_row1_hfontweight'))
{
	$maincolumn_row1_hfontweight = $this->params->get('maincolumn_row1_hfontweight');
}
if ($this->params->get('maincolumn_row1_linkcolor'))
{
	$maincolumn_row1_linkcolor = $this->params->get('maincolumn_row1_linkcolor');
}
if ($this->params->get('maincolumn_row1_linkcolorhover') && $body_bgpattern == 'custom')
{
	$maincolumn_row1_linkcolorhover = $this->params->get('maincolumn_row1_linkcolorhover');
}
if ($this->params->get('maincolumn_row1_bordercolor') && $body_bgpattern == 'custom')
{
	$maincolumn_row1_bordercolor = $this->params->get('maincolumn_row1_bordercolor');
}
if ($this->params->get('maincolumn_row1_innerbordercolor') && $body_bgpattern == 'custom')
{
	$maincolumn_row1_innerbordercolor = $this->params->get('maincolumn_row1_innerbordercolor');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$maincolumn_row1_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row1.png';
$maincolumn_row1_listimghover =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row1.hover.png';
$maincolumn_row1_readmore =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/readmore.cnt.row1.png';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 1 Dimensions

$maincolumn_row1  = 0;
$maincolumn_row1  += (bool) $this->countModules('position-20');
$maincolumn_row1  += (bool) $this->countModules('position-21'); 
$maincolumn_row1  += (bool) $this->countModules('position-22'); 
$maincolumn_row1  += (bool) $this->countModules('position-23'); 

$maincolumn_row1_width = 'style="width:auto;"';

if ($rightcolumn && $leftcolumn)
{
	if($maincolumn_row1 == 2)
	{
		$maincolumn_row1_colwidth = 'style="width:192px;"';	
	}
	else if($maincolumn_row1 == 3)
	{
		$maincolumn_row1_colwidth = 'style="width:120px;"';	
	}
	else if($maincolumn_row1 == 4)
	{
		$maincolumn_row1_colwidth = 'style="width:192px;"';	
	}
	else
	{
		$maincolumn_row1_colwidth = 'style="width:410px;"';	
	}	
}
else if (($rightcolumn && !$leftcolumn) || (!$rightcolumn && $leftcolumn))
{
	if($maincolumn_row1 == 2)
	{
		$maincolumn_row1_colwidth = 'style="width:327px;"';	
	}
	else if($maincolumn_row1 == 3)
	{
		$maincolumn_row1_colwidth = 'style="width:210px;"';	
	}
	else if($maincolumn_row1 == 4)
	{
		$maincolumn_row1_colwidth = 'style="width:151px;"';	
	}
	else
	{
		$maincolumn_row1_colwidth = 'style="width:680px;"';	
	}	
}
else
{
	if($maincolumn_row1 == 2)
	{
		$maincolumn_row1_colwidth = 'style="width:462px;"';	
	}
	else if($maincolumn_row1 == 3)
	{
		$maincolumn_row1_colwidth = 'style="width:300px;"';	
	}
	else if($maincolumn_row1 == 4)
	{
		$maincolumn_row1_colwidth = 'style="width:218px;"';	
	}
	else
	{
		$maincolumn_row1_colwidth = 'style="width:950px;"';	
	}	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row1 Separators

$maincolumn_row1_separator1 = 0;
$maincolumn_row1_separator2 = 0;
$maincolumn_row1_separator3 = 0;

$maincolumn_row1_separator1 += (bool)($this->countModules('position-20') && ($this->countModules('position-21') ||
                          				                    				   $this->countModules('position-22') ||
                                        				      				   $this->countModules('position-23')));

$maincolumn_row1_separator2 += (bool)(($this->countModules('position-20') || $this->countModules('position-21')) && 
					  			      ($this->countModules('position-22') || $this->countModules('position-23')));
					
$maincolumn_row1_separator3 += (bool)(($this->countModules('position-20') || 
									   $this->countModules('position-21') ||
									   $this->countModules('position-22')) && ($this->countModules('position-23')));


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 2

$maincolumn_row2_bgcolor = $body_bgcolor;
$maincolumn_row2_fontcolor = '3F3C38';

$maincolumn_row2_hfontcolor = '3F3C38';
$maincolumn_row2_hfontsize = '15px';
$maincolumn_row2_hfontweight = 'bold';

$maincolumn_row2_linkcolor = '3F3C38';
$maincolumn_row2_linkcolorhover = '990000';

$maincolumn_row2_bordercolor = '';
$maincolumn_row2_innerbordercolor = '';

switch($body_bgpattern)
{
	case 'autumn':
		$maincolumn_row2_linkcolorhover = 'A16849';
		break;
	case 'black':
		$maincolumn_row2_linkcolorhover = '990000';
		break;
	case 'forest':
		$maincolumn_row2_linkcolorhover = 'FFA41C';
		break;	
	case 'royal':
		$maincolumn_row2_linkcolorhover = 'FFA41C';
		break;				
	case 'silver':
		$maincolumn_row2_linkcolorhover = 'FFA41C';
		break;				
}

if ($this->params->get('maincolumn_row2_bgcolor'))
{
	$maincolumn_row2_bgcolor = $this->params->get('maincolumn_row2_bgcolor');
}
if ($this->params->get('maincolumn_row2_fontcolor'))
{
	$maincolumn_row2_fontcolor = $this->params->get('maincolumn_row2_fontcolor');
}
if ($this->params->get('maincolumn_row2_hfontcolor'))
{
	$maincolumn_row2_hfontcolor = $this->params->get('maincolumn_row2_hfontcolor');
}
if ($this->params->get('maincolumn_row2_hfontsize'))
{
	$maincolumn_row2_hfontsize = $this->params->get('maincolumn_row2_hfontsize');
}
if ($this->params->get('maincolumn_row2_hfontweight'))
{
	$maincolumn_row2_hfontweight = $this->params->get('maincolumn_row2_hfontweight');
}
if ($this->params->get('maincolumn_row2_linkcolor'))
{
	$maincolumn_row2_linkcolor = $this->params->get('maincolumn_row2_linkcolor');
}
if ($this->params->get('maincolumn_row2_linkcolorhover') && $body_bgpattern == 'custom')
{
	$maincolumn_row2_linkcolorhover = $this->params->get('maincolumn_row2_linkcolorhover');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$maincolumn_row2_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row2.png';
$maincolumn_row2_listimghover =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row2.hover.png';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 2 Dimensions


$maincolumn_row2 = 0;
$maincolumn_row2 += (bool) $this->countModules('position-24');
$maincolumn_row2 += (bool) $this->countModules('position-25'); 
$maincolumn_row2 += (bool) $this->countModules('position-26'); 
$maincolumn_row2 += (bool) $this->countModules('position-27'); 

$maincolumn_row2_colwidth = 'style="width:auto;"';

if ($rightcolumn && $leftcolumn)
{
	if($maincolumn_row2 == 2)
	{
		$maincolumn_row2_colwidth = 'style="width:218px;"';	
	}
	else if($maincolumn_row2 == 3)
	{
		$maincolumn_row2_colwidth = 'style="width:137px;"';	
	}
	else if($maincolumn_row2 == 4)
	{
		$maincolumn_row2_colwidth = 'style="width:218px;"';	
	}
}
else if (($rightcolumn && !$leftcolumn) || (!$rightcolumn && $leftcolumn))
{
	if($maincolumn_row2 == 2)
	{
		$maincolumn_row2_colwidth = 'style="width:353px;"';	
	}
	else if($maincolumn_row2 == 3)
	{
		$maincolumn_row2_colwidth = 'style="width:227px;"';	
	}
	else if($maincolumn_row2 == 4)
	{
		$maincolumn_row2_colwidth = 'style="width:164px;"';	
	}
}
else
{
	if($maincolumn_row2 == 2)
	{
		$maincolumn_row2_colwidth = 'style="width:488px;"';	
	}
	else if($maincolumn_row2 == 3)
	{
		$maincolumn_row2_colwidth = 'style="width:317px;"';	
	}
	else if($maincolumn_row2 == 4)
	{
		$maincolumn_row2_colwidth = 'style="width:231px;"';	
	}
	else
	{
		$maincolumn_row2_colwidth = 'style="width:1002px;"';	
	}	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 2 Separators


$maincolumn_row2_separator1 = 0;
$maincolumn_row2_separator2 = 0;
$maincolumn_row2_separator3 = 0;

$maincolumn_row2_separator1 += (bool)($this->countModules('position-24') && ($this->countModules('position-25') ||
                                              								   $this->countModules('position-26') ||
                                              								   $this->countModules('position-27')));

$maincolumn_row2_separator2 += (bool)(($this->countModules('position-24') || $this->countModules('position-25')) && 
				  					  ($this->countModules('position-26') || $this->countModules('position-27')));
					
$maincolumn_row2_separator3 += (bool)(($this->countModules('position-24') || 
										 $this->countModules('position-25') ||
										 $this->countModules('position-26')) && ($this->countModules('position-27')));



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 3

$maincolumn_row3_bgcolor = 'F4F4F4';
$maincolumn_row3_fontcolor = '3F3C38';

$maincolumn_row3_hfontcolor = '3F3C38';
$maincolumn_row3_hfontsize = '15px';
$maincolumn_row3_hfontweight = 'bold';

$maincolumn_row3_linkcolor = '3F3C38';
$maincolumn_row3_linkcolorhover = '990000';

$maincolumn_row3_bordercolor = 'CCCCCC';
$maincolumn_row3_innerbordercolor = 'FFFFFF';

switch($body_bgpattern)
{
	case 'autumn':
		$maincolumn_row3_linkcolorhover = 'A16849';
		break;
	case 'black':
		$maincolumn_row3_linkcolorhover = '990000';
		break;	
	case 'forest':
		$maincolumn_row3_linkcolorhover = 'FFA41C';
		break;	
	case 'royal':
		$maincolumn_row3_linkcolorhover = 'FFA41C';
		break;	
	case 'silver':
		$maincolumn_row3_linkcolorhover = 'FFA41C';
		break;					
}

if ($this->params->get('maincolumn_row3_bgcolor'))
{
	$maincolumn_row3_bgcolor = $this->params->get('maincolumn_row3_bgcolor');
}
if ($this->params->get('maincolumn_row3_fontcolor'))
{
	$maincolumn_row3_fontcolor = $this->params->get('maincolumn_row3_fontcolor');
}
if ($this->params->get('maincolumn_row3_hfontcolor'))
{
	$maincolumn_row3_hfontcolor = $this->params->get('maincolumn_row3_hfontcolor');
}
if ($this->params->get('maincolumn_row3_hfontsize'))
{
	$maincolumn_row3_hfontsize = $this->params->get('maincolumn_row3_hfontsize');
}
if ($this->params->get('maincolumn_row3_hfontweight'))
{
	$maincolumn_row3_hfontweight = $this->params->get('maincolumn_row3_hfontweight');
}
if ($this->params->get('maincolumn_row3_linkcolor'))
{
	$maincolumn_row3_linkcolor = $this->params->get('maincolumn_row3_linkcolor');
}
if ($this->params->get('maincolumn_row3_linkcolorhover') && $body_bgpattern == 'custom')
{
	$maincolumn_row3_linkcolorhover = $this->params->get('maincolumn_row3_linkcolorhover');
}
if ($this->params->get('maincolumn_row3_bordercolor'))
{
	$maincolumn_row3_bordercolor = $this->params->get('maincolumn_row3_bordercolor');
}
if ($this->params->get('maincolumn_row3_innerbordercolor'))
{
	$maincolumn_row3_innerbordercolor = $this->params->get('maincolumn_row3_innerbordercolor');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$maincolumn_row3_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row3.png';
$maincolumn_row3_listimghover =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row3.hover.png';
$maincolumn_row3_readmore =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/readmore.cnt.row3.png';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 3 Dimensions


$maincolumn_row3 = 0;
$maincolumn_row3 += (bool) $this->countModules('position-28');
$maincolumn_row3 += (bool) $this->countModules('position-29'); 
$maincolumn_row3 += (bool) $this->countModules('position-30'); 
$maincolumn_row3 += (bool) $this->countModules('position-31'); 

$maincolumn_row3_colwidth = 'style="width:auto;"';

if ($rightcolumn && $leftcolumn)
{
	if($maincolumn_row3 == 2)
	{
		$maincolumn_row3_colwidth = 'style="width:192px;"';	
	}
	else if($maincolumn_row3 == 3)
	{
		$maincolumn_row3_colwidth = 'style="width:120px;"';	
	}
	else if($maincolumn_row3 == 4)
	{
		$maincolumn_row3_colwidth = 'style="width:192px;"';	
	}
}
else if (($rightcolumn && !$leftcolumn) || (!$rightcolumn && $leftcolumn))
{
	if($maincolumn_row3 == 2)
	{
		$maincolumn_row3_colwidth = 'style="width:327px;"';	
	}
	else if($maincolumn_row3 == 3)
	{
		$maincolumn_row3_colwidth = 'style="width:210px;"';	
	}
	else if($maincolumn_row3 == 4)
	{
		$maincolumn_row3_colwidth = 'style="width:151px;"';	
	}
}
else
{
	if($maincolumn_row3 == 2)
	{
		$maincolumn_row3_colwidth = 'style="width:462px;"';	
	}
	else if($maincolumn_row3 == 3)
	{
		$maincolumn_row3_colwidth = 'style="width:300px;"';	
	}
	else if($maincolumn_row3 == 4)
	{
		$maincolumn_row3_colwidth = 'style="width:218px;"';	
	}
	else
	{
		$maincolumn_row3_colwidth = 'style="width:952px;"';	
	}		
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 3 Separators


$maincolumn_row3_separator1 = 0;
$maincolumn_row3_separator2 = 0;
$maincolumn_row3_separator3 = 0;

$maincolumn_row3_separator1 += (bool)($this->countModules('position-28') && ($this->countModules('position-29') ||
                                              								   $this->countModules('position-30') ||
                                              								   $this->countModules('position-31')));

$maincolumn_row3_separator2 += (bool)(($this->countModules('position-28') || $this->countModules('position-29')) && 
				    				($this->countModules('position-30') || $this->countModules('position-31')));
					
$maincolumn_row3_separator3 += (bool)(($this->countModules('position-28') || 
									 $this->countModules('position-29') ||
									 $this->countModules('position-30')) && ($this->countModules('position-31')));


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 4

$maincolumn_row4_bgcolor = 'F4F4F4';
$maincolumn_row4_fontcolor = '3F3C38';

$maincolumn_row4_hfontcolor = '3F3C38';
$maincolumn_row4_hfontsize = '15px';
$maincolumn_row4_hfontweight = 'bold';

$maincolumn_row4_linkcolor = '3F3C38';
$maincolumn_row4_linkcolorhover = '990000';

$maincolumn_row4_bordercolor = 'CCCCCC';
$maincolumn_row4_innerbordercolor = 'FFFFFF';

switch($body_bgpattern)
{
	case 'autumn':
		$maincolumn_row4_linkcolorhover = 'A16849';
		break;
	case 'black':
		$maincolumn_row4_linkcolorhover = '990000';
		break;	
	case 'forest':
		$maincolumn_row4_linkcolorhover = 'FFA41C';
		break;	
	case 'royal':
		$maincolumn_row4_linkcolorhover = 'FFA41C';
		break;	
	case 'silver':
		$maincolumn_row4_linkcolorhover = 'FFA41C';
		break;					
}

if ($this->params->get('maincolumn_row4_bgcolor'))
{
	$maincolumn_row4_bgcolor = $this->params->get('maincolumn_row4_bgcolor');
}
if ($this->params->get('maincolumn_row4_fontcolor'))
{
	$maincolumn_row4_fontcolor = $this->params->get('maincolumn_row4_fontcolor');
}
if ($this->params->get('maincolumn_row4_hfontcolor'))
{
	$maincolumn_row4_hfontcolor = $this->params->get('maincolumn_row4_hfontcolor');
}
if ($this->params->get('maincolumn_row4_hfontsize'))
{
	$maincolumn_row4_hfontsize = $this->params->get('maincolumn_row4_hfontsize');
}
if ($this->params->get('maincolumn_row4_hfontweight'))
{
	$maincolumn_row4_hfontweight = $this->params->get('maincolumn_row4_hfontweight');
}
if ($this->params->get('maincolumn_row4_linkcolor'))
{
	$maincolumn_row4_linkcolor = $this->params->get('maincolumn_row4_linkcolor');
}
if ($this->params->get('maincolumn_row4_linkcolorhover') && $body_bgpattern == 'custom')
{
	$maincolumn_row4_linkcolorhover = $this->params->get('maincolumn_row4_linkcolorhover');
}
if ($this->params->get('maincolumn_row4_bordercolor'))
{
	$maincolumn_row4_bordercolor = $this->params->get('maincolumn_row4_bordercolor');
}
if ($this->params->get('maincolumn_row4_innerbordercolor'))
{
	$maincolumn_row4_innerbordercolor = $this->params->get('maincolumn_row4_innerbordercolor');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$maincolumn_row4_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row4.png';
$maincolumn_row4_listimghover =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row4.hover.png';


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 4 Dimensions


$maincolumn_row4 = 0;
$maincolumn_row4 += (bool) $this->countModules('position-32');
$maincolumn_row4 += (bool) $this->countModules('position-33'); 
$maincolumn_row4 += (bool) $this->countModules('position-34'); 
$maincolumn_row4 += (bool) $this->countModules('position-35'); 

$maincolumn_row4_colwidth = 'style="width:auto;"';

if ($rightcolumn && $leftcolumn)
{
	if($maincolumn_row4 == 2)
	{
		$maincolumn_row4_colwidth = 'style="width:191px;"';	
	}
	else if($maincolumn_row4 == 3)
	{
		$maincolumn_row4_colwidth = 'style="width:119px;"';	
	}
	else if($maincolumn_row4 == 4)
	{
		$maincolumn_row4_colwidth = 'style="width:191px;"';	
	}
	else
	{
		$maincolumn_row4_colwidth = 'style="width:409px;"';	
	}	
}
else if (($rightcolumn && !$leftcolumn) || (!$rightcolumn && $leftcolumn))
{
	if($maincolumn_row4 == 2)
	{
		$maincolumn_row4_colwidth = 'style="width:327px;"';	
	}
	else if($maincolumn_row4 == 3)
	{
		$maincolumn_row4_colwidth = 'style="width:210px;"';	
	}
	else if($maincolumn_row4 == 4)
	{
		$maincolumn_row4_colwidth = 'style="width:151px;"';	
	}
	else
	{
		$maincolumn_row4_colwidth = 'style="width:680px;"';	
	}	
}
else
{
	if($maincolumn_row4 == 2)
	{
		$maincolumn_row4_colwidth = 'style="width:462px;"';	
	}
	else if($maincolumn_row4 == 3)
	{
		$maincolumn_row4_colwidth = 'style="width:300px;"';	
	}
	else if($maincolumn_row4 == 4)
	{
		$maincolumn_row4_colwidth = 'style="width:218px;"';	
	}
	else
	{
		$maincolumn_row4_colwidth = 'style="width:950px;"';	
	}	
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 4 Separators


$maincolumn_row4_separator1 = 0;
$maincolumn_row4_separator2 = 0;
$maincolumn_row4_separator3 = 0;

$maincolumn_row4_separator1 += (bool)($this->countModules('position-32') && ($this->countModules('position-33') ||
                                              				   $this->countModules('position-34') ||
                                              				   $this->countModules('position-35')));

$maincolumn_row4_separator2 += (bool)(($this->countModules('position-32') || $this->countModules('position-33')) && 
				    ($this->countModules('position-34') || $this->countModules('position-35')));
					
$maincolumn_row4_separator3 += (bool)(($this->countModules('position-32') || 
					 $this->countModules('position-33') ||
					 $this->countModules('position-34')) && ($this->countModules('position-35')));

					 
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 5

$maincolumn_row5_bgcolor = '000000';
$maincolumn_row5_fontcolor = 'FFFFFF';

$maincolumn_row5_hfontcolor = 'FFFFFF';
$maincolumn_row5_hfontsize = '15px';
$maincolumn_row5_hfontweight = 'bold';

$maincolumn_row5_linkcolor = 'FFFFFF';
$maincolumn_row5_linkcolorhover = '990000';

$maincolumn_row5_bordercolor = '000000';
$maincolumn_row5_innerbordercolor = '000000';

switch($body_bgpattern)
{
	case 'autumn':
		$maincolumn_row5_bgcolor = '6C2111';
		$maincolumn_row5_linkcolorhover = 'FFA41C';
		$maincolumn_row5_bordercolor = '6C2111';
		$maincolumn_row5_innerbordercolor = '803F32';		
		break;
	case 'black':
		$maincolumn_row5_bgcolor = '000000';
		$maincolumn_row5_linkcolorhover = '990000';
		$maincolumn_row5_bordercolor = '000000';
		$maincolumn_row5_innerbordercolor = '000000';	
		break;	
	case 'forest':
		$maincolumn_row5_bgcolor = '364518';
		$maincolumn_row5_linkcolorhover = 'FFA41C';
		$maincolumn_row5_bordercolor = '364518';
		$maincolumn_row5_innerbordercolor = '364518';		
		break;			
	case 'royal':
		$maincolumn_row5_bgcolor = '1E3253';
		$maincolumn_row5_linkcolorhover = 'FFA41C';
		$maincolumn_row5_bordercolor = '1E3253';
		$maincolumn_row5_innerbordercolor = '1E3253';		
		break;			
	case 'silver':
		$maincolumn_row5_bgcolor = '5C5C5C';
		$maincolumn_row5_linkcolorhover = 'FFA41C';
		$maincolumn_row5_bordercolor = '5C5C5C';
		$maincolumn_row5_innerbordercolor = '5C5C5C';		
		break;			
}

if ($this->params->get('maincolumn_row5_bgcolor') && $body_bgpattern == 'custom')
{
	$maincolumn_row5_bgcolor = $this->params->get('maincolumn_row5_bgcolor');
}
if ($this->params->get('maincolumn_row5_fontcolor'))
{
	$maincolumn_row5_fontcolor = $this->params->get('maincolumn_row5_fontcolor');
}
if ($this->params->get('maincolumn_row5_hfontcolor'))
{
	$maincolumn_row5_hfontcolor = $this->params->get('maincolumn_row5_hfontcolor');
}
if ($this->params->get('maincolumn_row5_hfontsize'))
{
	$maincolumn_row5_hfontsize = $this->params->get('maincolumn_row5_hfontsize');
}
if ($this->params->get('maincolumn_row5_hfontweight'))
{
	$maincolumn_row5_hfontweight = $this->params->get('maincolumn_row5_hfontweight');
}
if ($this->params->get('maincolumn_row5_linkcolor'))
{
	$maincolumn_row5_linkcolor = $this->params->get('maincolumn_row5_linkcolor');
}
if ($this->params->get('maincolumn_row5_linkcolorhover') && $body_bgpattern == 'custom')
{
	$maincolumn_row5_linkcolorhover = $this->params->get('maincolumn_row5_linkcolorhover');
}
if ($this->params->get('maincolumn_row5_bordercolor') && $body_bgpattern == 'custom')
{
	$maincolumn_row5_bordercolor = $this->params->get('maincolumn_row5_bordercolor');
}
if ($this->params->get('maincolumn_row5_innerbordercolor') && $body_bgpattern == 'custom')
{
	$maincolumn_row5_innerbordercolor = $this->params->get('maincolumn_row5_innerbordercolor');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$maincolumn_row5_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row5.png';
$maincolumn_row5_listimghover =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.cnt.row5.hover.png';
$maincolumn_row5_readmore =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/readmore.cnt.row5.png';

					 
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row 5 Dimensions


$maincolumn_row5 = 0;
$maincolumn_row5 += (bool) $this->countModules('position-36');
$maincolumn_row5 += (bool) $this->countModules('position-37'); 
$maincolumn_row5 += (bool) $this->countModules('position-38'); 
$maincolumn_row5 += (bool) $this->countModules('position-39'); 

$maincolumn_row5_colwidth = 'style="width:auto;"';

if ($rightcolumn && $leftcolumn)
{
	if($maincolumn_row5 == 2)
	{
		$maincolumn_row5_colwidth = 'style="width:1912px;"';	
	}
	else if($maincolumn_row5 == 3)
	{
		$maincolumn_row5_colwidth = 'style="width:120px;"';	
	}
	else if($maincolumn_row5 == 4)
	{
		$maincolumn_row5_colwidth = 'style="width:192px;"';	
	}
}
else if (($rightcolumn && !$leftcolumn) || (!$rightcolumn && $leftcolumn))
{
	if($maincolumn_row5 == 2)
	{
		$maincolumn_row5_colwidth = 'style="width:327px;"';	
	}
	else if($maincolumn_row5 == 3)
	{
		$maincolumn_row5_colwidth = 'style="width:210px;"';	
	}
	else if($maincolumn_row5 == 4)
	{
		$maincolumn_row5_colwidth = 'style="width:151px;"';	
	}
}
else
{
	if($maincolumn_row5 == 2)
	{
		$maincolumn_row5_colwidth = 'style="width:462px;"';	
	}
	else if($maincolumn_row5 == 3)
	{
		$maincolumn_row5_colwidth = 'style="width:300px;"';	
	}
	else if($maincolumn_row5 == 4)
	{
		$maincolumn_row5_colwidth = 'style="width:218px;"';	
	}
	else
	{
		$maincolumn_row5_colwidth = 'style="width:952px;"';	
	}		
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Main Column - Row5 Separators

$maincolumn_row5_separator1 = 0;
$maincolumn_row5_separator2 = 0;
$maincolumn_row5_separator3 = 0;

$maincolumn_row5_separator1 += (bool)($this->countModules('position-36') && ($this->countModules('position-37') ||
                                              								   $this->countModules('position-38') ||
                                              								   $this->countModules('position-39')));

$maincolumn_row5_separator2 += (bool)(($this->countModules('position-36') || $this->countModules('position-37')) && 
				   					 ($this->countModules('position-38') || $this->countModules('position-39')));
					
$maincolumn_row5_separator3 += (bool)(($this->countModules('position-36') || 
										 $this->countModules('position-37') ||
										 $this->countModules('position-38')) && ($this->countModules('position-39')));
					 
					 					 
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Footer
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$footer_fontcolor = 'FFFFFF';

$footer_hfontsize = '15';
$footer_hfontweight = 'bold';
$footer_hfontcolor = 'FFFFFF';

$footer_linkcolor = 'FFFFFF'; 
$footer_linkcolorhover = '990000';

switch($body_bgpattern)
{
	case 'autumn':
		$footer_linkcolorhover = 'FFA41C';	
		break;
	case 'black':
		$footer_linkcolorhover = '990000';
		break;	
	case 'forest':
		$footer_linkcolorhover = 'FFA41C';	
		break;	
	case 'royal':
		$footer_linkcolorhover = 'FFA41C';	
		break;	
	case 'silver':
		$footer_linkcolorhover = 'FFA41C';	
		break;			
}

if ($this->params->get('footer_fontcolor'))
{
	$footer_fontcolor = $this->params->get('footer_fontcolor');
}
if ($this->params->get('footer_hfontsize'))
{
	$footer_hfontsize = $this->params->get('footer_hfontsize');
}
if ($this->params->get('footer_hfontweight'))
{
	$footer_hfontweight = $this->params->get('footer_hfontweight');
}
if ($this->params->get('footer_hfontcolor'))
{
	$footer_hfontcolor = $this->params->get('footer_hfontcolor');
}
if ($this->params->get('footer_linkcolor'))
{
	$footer_linkcolor = $this->params->get('footer_linkcolor');
}
if ($this->params->get('footer_linkcolorhover') && $body_bgpattern == 'custom')
{
	$footer_linkcolorhover = $this->params->get('footer_linkcolorhover');
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$footer_bgcontactus =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/bg.footer.contactus.png';
$footer_listimg =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.footer.png';
$footer_listimghover =  $this->baseurl . '/templates/' . $this->template . '/images/themes/' . $body_bgpattern . '/listimg.footer.hover.png';

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Footer - Row 1 


$footer_row1_bgcolor = '000000';

switch($body_bgpattern)
{
	case 'autumn':
		$footer_row1_bgcolor = '6C2111';
		break;
	case 'black':
		$footer_row1_bgcolor = '000000';
		break;	
	case 'forest':
		$footer_row1_bgcolor = '364518';
		break;	
	case 'royal':
		$footer_row1_bgcolor = '1E3253';
		break;				
	case 'silver':
		$footer_row1_bgcolor = '5C5C5C';
		break;				
}

if ($this->params->get('footer_row1_bgcolor') && $body_bgpattern == 'custom')
{
	$footer_row1_bgcolor = $this->params->get('footer_row1_bgcolor');
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Footer - Row 1 Dimensions


$footer_row1 = 0;
$footer_row1 += (bool) $this->countModules('position-50');
$footer_row1 += (bool) $this->countModules('position-52');
$footer_row1 += (bool) $this->countModules('position-53');

$footer_row1_colwidth = 'style="width:1002px;"';	

if($footer_row1 == 2)
{
	$footer_row1_colwidth = 'style="width:487px;"';	
}
else if($footer_row1 == 3)
{
	$footer_row1_colwidth = 'style="width:316px;"';	
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Footer - Row1 Separators

$footer_row1_separator1 = 0;
$footer_row1_separator2 = 0;
$footer_row1_separator3 = 0;

$footer_row1_separator1 += (bool)($this->countModules('position-50') && ($this->countModules('position-51') ||
                                     			         				    $this->countModules('position-52') ||
                                         			     				    $this->countModules('position-53')));

$footer_row1_separator2 += (bool)(($this->countModules('position-50') || $this->countModules('position-51')) && 
				   				  ($this->countModules('position-52') || $this->countModules('position-53')));
					
$footer_row1_separator3 += (bool)(($this->countModules('position-50') || 
								  $this->countModules('position-51') ||
								  $this->countModules('position-52')) && ($this->countModules('position-53')));
					 
					 
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Footer - Row 2


$footer_row2_bgcolor = '000000';

switch($body_bgpattern)
{
	case 'autumn':
		$footer_row2_bgcolor = '530F00';
		break;
	case 'black':
		$footer_row2_bgcolor = '000000';
		break;			
	case 'forest':
		$footer_row2_bgcolor = '222E00';
		break;	
	case 'royal':
		$footer_row2_bgcolor = '13223C';
		break;				
	case 'silver':
		$footer_row2_bgcolor = '5C5C5C';
		break;			
}

if ($this->params->get('footer_row2_bgcolor') && $body_bgpattern == 'custom')
{
	$footer_row2_bgcolor = $this->params->get('footer_row2_bgcolor');
}



?>
